/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize
#define iDate vec4(0.0,0.0,0.0,iGlobalTime)

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract


/////////////////////////////////////////////////////////////////////////////////

#define NUM_DRIPS 20

float Seed;

void srand (float t)
{
    Seed = 0.5 + (sin (t*59.0) + sin (t*73.0) + sin (t*97.0))/6.0;
}
    
float rand()
{
    Seed = 0.25 + 0.5*Seed + 0.25*sin (12345.0 * Seed);
    return Seed;
}

vec2 dripPos (float fTime, out float fAge)
{
    float t = floor (fTime*0.1);
    srand (t);
    fAge = fTime*0.1 - t;
    return vec2 (rand(), rand());
}

void main(void)
{
	 vec2 vRel = gl_FragCoord.xy / iResolution.xy;
    vRel.y = 1.0 - vRel.y; // Flip y. TheEmu.

    float t = iGlobalTime;
    float fStep = 123.456;
    float fHeight = 0.0;
    
    for (int i = 0; i < NUM_DRIPS; i++)
    {
        float fAge;
        vec2 vRnd = dripPos (t, fAge);

        // float fDx = vRel.x - vRnd.x;
        // float fDy = vRel.y - vRnd.y;
        // float fD2 = fDx*fDx + fDy*fDy;
        // float fD = sqrt (fD2);
        
        // the above, simpler:
        vec2 vD = vec2 (vRel - vRnd);
        float fD = sqrt (dot (vD, vD));

        float fDa = 10.0 * (fD - fAge + 0.6);

        fHeight += (1.0 - fAge) 
            * max (0.0, 1.0 - (fDa*fDa))
            * sin (fD*150.0 - fAge*80.0);
        
        t += fStep;
    }

    vRel.y -= sign (fHeight) * fHeight*fHeight;
    vec4 vTex = texture2D (iChannel0, vRel);
    if ( vTex.a < 1.0 ) vTex = vec4(0.0);

    if (fHeight < 0.0)
    {
        float p = -fHeight*0.8;
        float q = 1.0 - p;
        vTex.b = p + q*vTex.b;
        p = -fHeight*0.3;
        q = 1.0 - p;
        vTex.g = p + q*vTex.g;
    }
    
    gl_FragColor = vTex; 
}